﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;
using System.Xml;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "UCEVENTEDT")]


public partial class ucEventEdit : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7529 US:7358 ok button handler for pathway event edit popup
    /// </summary>
    protected void OnEvtEditOK(object sender, DirectEventArgs e)
    {
        //should we adjust future dates?
        long lAdjustFuture = 0;
        if (chkEDPWAdjustFuture.Checked)
        {
            lAdjustFuture = 1;
        }

        //inserting a new event
        if (EventType == "0")
        {
            //update event info 
            CCPA cpa = new CCPA();
            bool bStatus = cpa.InsertPWEvent(BaseMstr,
                                             BaseMstr.SelectedPatientID,
                                             CDataUtils2.ToLong(PatPWID),
                                             BaseMstr.RegionID,
                                             BaseMstr.SiteID,
                                             tfEDPWEventTitle.Text,
                                             dfEDPWEventDate.SelectedDate,
                                             lAdjustFuture);

            if (!bStatus)
            {
                BaseMstr.ShowSystemFeedback("Error inserting the event, please contact your system administrator!", "Error");
                return;
            }

        }
        else
        {

            //update event info 
            CCPA cpa = new CCPA();
            bool bStatus = cpa.UpdatePWEvent(BaseMstr,
                                     BaseMstr.SelectedPatientID,
                                     CDataUtils2.ToLong(PatPWEventID),
                                     tfEDPWEventTitle.Text,
                                     dfEDPWEventDate.SelectedDate,
                                     lAdjustFuture);

            if (!bStatus)
            {
                BaseMstr.ShowSystemFeedback("Error updating the event, please contact your system administrator!", "Error");
                return;
            }
        }
   
        
        wndEventEdt.Hide();
    }

    /// <summary>
    /// US:7529 US:7358 patient pathway event id
    /// </summary>
    public string PatPWEventID
    {
        get
        {
            string strValue = "";
            if (Session["UCEVTEDT_PATPWEVENTID"] != null)
            {
                strValue = Session["UCEVTEDT_PATPWEVENTID"].ToString();
            }

            return strValue;
        }
        set { Session["UCEVTEDT_PATPWEVENTID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:7529 US:7358 patient pathway event id
    /// </summary>
    public string PatPWID
    {
        get
        {
            string strValue = "";
            if (Session["UCEVTEDT_PatPWID"] != null)
            {
                strValue = Session["UCEVTEDT_PatPWID"].ToString();
            }

            return strValue;
        }
        set { Session["UCEVTEDT_PatPWID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:7529 event type, 0=new 1=edit
    /// </summary>
    public string EventType
    {
        get
        {
            string strValue = "";
            if (Session["UCEVTEDT_EventType"] != null)
            {
                strValue = Session["UCEVTEDT_EventType"].ToString();
            }

            return strValue;
        }
        set { Session["UCEVTEDT_EventType"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:7529 US:7358 page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    /// <summary>
    ///US:7529 US:7358 show the edit pathway event popup
    /// </summary>
    public void Show(int nType)
    {
        EventType = Convert.ToString(nType);

        //exisiting event
        if (nType == 1)
        {
            chkEDPWAdjustFuture.Show();

            wndEventEdt.Title = "Edit Title and Date";
            
            //get event info
            CCPA cpa = new CCPA();
            DataSet dsEvent = cpa.GetPatPWEventByIDDS(BaseMstr, BaseMstr.SelectedPatientID, CDataUtils2.ToLong(PatPWEventID));

            tfEDPWEventTitle.Text = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(dsEvent, "EVENT_TITLE"));

            dfEDPWEventDate.SelectedDate = CDataUtils2.GetDSDateTimeValue(dsEvent, "DATE_SCHEDULED");
        }
        //new event
        if (nType == 0)
        {
            chkEDPWAdjustFuture.Hide();

            wndEventEdt.Title = "Add Event";

            tfEDPWEventTitle.Text = "";
            dfEDPWEventDate.SelectedDate = DateTime.Today;
        }
        
        chkEDPWAdjustFuture.Checked = false;
        tfEDPWEventTitle.Focus();

        //show the window
        wndEventEdt.Show();
    }
}